#ifndef _COM_H_
#define _COM_H_
//#define		PACKET_HEADER
#define		MCBSP_PACKET_HEADER					0xA5A5
#define		RS232_PACKET_HEADER					0xA5A5
#define		PACKET_MODE_RS232					0x0001
#define		PACKET_MODE_MCBSP					0x0002

#define MCBSP_BROADCAST_DESTINATION				0xF0F0
#define MCBSP_PACKET_MAX_SIZE_WORD				256					// by word(32 bits)

#define MCBSP_PACKET_DEFAULT_SIZE				6
#define MCBSP_PACKET_HEADER_SIZE				5
#define MCBSP_RESPOND_DEFAULT_SIZE				(MCBSP_PACKET_DEFAULT_SIZE + 1)

//#define USB_PACKET_HEADER_SIZE				5
#define	USB_PACKET_HEADER						0xA5A5
#define TCP_PACKET_HEADER						0xA5A5
#define USB_DATA_MAX_SIZE						(96 * 1024)			// by byte(8 bits)
#define PACKET_USB_MAX_SIZE						(USB_DATA_MAX_SIZE + 80) // by byte(8 bits)

#define RS232_PACKET_DEFAULT_SIZE				6
#define RS232_RESPOND_DEFAULT_SIZE				(RS232_PACKET_DEFAULT_SIZE + 1)

#define PACKET_TYPE_ERROR_SHIFT					8
#define PACKET_TYPE_ERROR_MASK 					0x0100
#define PACKET_TYPE_ERROR_VALUE(error)			((error) << PACKET_TYPE_ERROR_SHIFT)

#define CMD_TYPE_SYS_APP_MASK					0x10
#define CMD_TYPE_SYS_REQUEST					0x01
#define CMD_TYPE_SYS_POLLING_RESULT				0x02
#define CMD_TYPE_SYS_RECEIVE_RESULT				0x03
#define CMD_TYPE_APP_REQUEST					0x11
#define CMD_TYPE_APP_POLLING_RESULT				0x12
#define CMD_TYPE_APP_RECEIVE_RESULT				0x13

#define CMD_STATUSLIST          				(('S' << 8) + 'L')
#define CMD_ERRORLIST          					(('E' << 8) + 'L')
//#define CMD_SINGLE_DATA						(('S' << 8) + 'D')
//#define CMD_DEFECTIMAGE        	 			(('D' << 8) + 'I')

// Processing


// PC-HCB
#define CMD_STATUS								(('S' << 8) + 'T')
#define CMD_PORT_READ        	 				(('P' << 8) + 'R')
#define CMD_PORT_AO_WRITE						(('P' << 8) + 'A')
#define CMD_PORT_TEST        	 				(('P' << 8) + 'T')
#define CMD_PORT_SETUP        	 				(('P' << 8) + 'Z')
#define CMD_RS485_TEST							(('4' << 8) + 'T')
#define CMD_RS485_TEST_STATUS					(('4' << 8) + 'S')
#define CMD_RS485_TEST_RX_DATA					(('4' << 8) + 'R')
#define CMD_RS485_DEBUG_INFO					(('4' << 8) + 'D')
#define CMD_MONITORING_DATA						(('O' << 8) + 'D')
#define	CMD_MACHINE_POWER_OFF					(('P' << 8) + 'O')
//#define CMD_SERVO_MOTOR        	 			(('S' << 8) + 'M')
#define CMD_SERVO_MOTOR        	 				(('X' << 8) + 'M')
#define CMD_MOVING_CAPTURE        	 			(('M' << 8) + 'C')
#define CMD_MCBSP_TEST							(('M' << 8) + 'T')
#define CMD_MCBSP_TEST_RESULT					(('M' << 8) + 'R')
#define CMD_MCBSP_DEBUG_INFO					(('M' << 8) + 'D')
#define CMD_TABLET_COUNTER						(('t' << 8) + 'c')
#define CMD_TABLET_CAPTURE						(('t' << 8) + 'p')
#define CMD_MACHINE_CONTROL        	 			(('C' << 8) + 'H')
#define CMD_LED_CHANGE    		      			(('L' << 8) + 'C')
//#define CMD_MACHINE_STATUS					(('M' << 8) + 'S')
#define CMD_READ_PORT_STATUS					(('Q' << 8) + 'S')
#define CMD_MACHINE_CAPTURE						(('h' << 8) + 'c')
#define CMD_MACHINE_CAPTURE_STOP				(('h' << 8) + 't')
#define CMD_TABLET_PROCESS_INFO        	 		(('t' << 8) + 'x')
#define CMD_TABLET_INSPECT_INFO        	 		(('t' << 8) + 'i')
#define CMD_CHECK_SENSOR_INTERVAL        	 	(('c' << 8) + 'i')
#define CMD_TABLET_TEST							(('t' << 8) + 't')
#define CMD_INSPECTION_RESULT					(('i' << 8) + 'u')
//#define CMD_ALARM_STATUS						(('A' << 8) + 'S')
//#define CMD_WARNING_STATUS					(('W' << 8) + 'S')
#define CMD_SET_MACHINE_MODE					(('M' << 8) + 'O')
#define CMD_USER_MACHINE_ENV_SETUP              (('U' << 8) + 'E')
#define CMD_ALARM_RESET                         (('A' << 8) + 'R')
#define CMD_CAMERA_RESET        	 			(('C' << 8) + 'R')
#define CMD_TERMINATION_INFO					(('T' << 8) + 'I')
#define CMD_INVALIDATE_TERMINATION_INFO			(('N' << 8) + 'T')
#define CMD_BUZZER_OFF                         	(('Z' << 8) + 'F')
#define CMD_READ_MACHINE_INFO					(('R' << 8) + 'M')
#define CMD_READ_USER_MACHINE_ENV				(('R' << 8) + 'V')
#define CMD_READ_PORT_MAP_INFO					(('R' << 8) + 'P')
#define CMD_READ_MS_HEADER						(('M' << 8) + 'H')
#define CMD_WRITE_MS_HEADER						(('W' << 8) + 'H')
#define CMD_UNMANED_OPERATION					(('U' << 8) + 'O')
#define CMD_READ_UNMANED_OPERATION_INFO			(('R' << 8) + 'U')
#define CMD_VIBRATOR_INFO						(('V' << 8) + 'I')
#define CMD_VIBRATOR_CHUL_DATA                  (('d' << 8) + '7')

// PC-HCB, PC-SPB
#define CMD_READ_PROGRAM_HEADER					(('0' << 8) + '0')
#define CMD_READ_DB_HEADER						(('0' << 8) + '1')
#define CMD_ECHO        	 					(('E' << 8) + 'H')
#define CMD_DOWNLOAD							(('D' << 8) + 'L')
#define CMD_RESET        	 					(('R' << 8) + 'T')
#define CMD_FLASH_INFO        	 				(('F' << 8) + 'I')
#define CMD_FLASH_FORMAT        	 			(('F' << 8) + 'F')
#define CMD_PROCESSING_TEST        	 			(('P' << 8) + 'T')
#define CMD_PROCESSING_TEST_RESULT        	 	(('P' << 8) + 'R')
#define CMD_READ_ERROR_LIST						(('E' << 8) + 'R')
#define CMD_SYSTEM_SETUP						(('S' << 8) + 'S')
#define CMD_READ_SYSTEM_SETUP					(('R' << 8) + 'S')
#define CMD_MACHINE_PARAM_SETUP                 (('P' << 8) + 'S')
#define CMD_INSPECTION_READY        	 		(('i' << 8) + 'r')
#define CMD_INSPECTION_END        	 			(('i' << 8) + 'e')
#define CMD_INSPECTION_RESUME        	 		(('i' << 8) + 'z')
//#define CMD_INSPECTION_SUSPEND        	 	(('i' << 8) + 'u')
#define CMD_STUDY_READY        	 				(('s' << 8) + 'r')
#define CMD_STUDY_END        	 				(('s' << 8) + 'e')
#define CMD_TABLET_COUNTER_READY        	 	(('c' << 8) + 'r')

#define CMD_LONG_WORK        	 				(('L' << 8) + 'W')
#define CMD_USB_TEST        	 				(('U' << 8) + 'T')
#define CMD_VERSION_INFO						(('V' << 8) + 'O')
#define CMD_FPGA_VERSION_INFO					(('V' << 8) + 'G')
#define CMD_READ_COMPATIBILITY					(('C' << 8) + 'V')
#define CMD_IDLE_PROCESS_INFO					(('I' << 8) + 'I')

// PC-SPB
#define CMD_OPERATION_START        	 			(('O' << 8) + 'S')
#define CMD_SETUP_DATA							(('s' << 8) + 't')
#define CMD_SETUP_DATA_3D						(('s' << 8) + '3')
#define CMD_TABLET_CHARACTER        	 		(('t' << 8) + 'c')
#define CMD_STUDY_DATA        	 				(('s' << 8) + 'd')
#define CMD_GRADE_DATA        	 				(('g' << 8) + 'd')
#define CMD_TABLET_CAPTURE_SETUP_DATA			(('c' << 8) + 'e')
#define CMD_READ_CPB_IMAGE        	 			(('R' << 8) + 'G')
#define CMD_PROCESSING_TIME						(('p' << 8) + 't')
#define CMD_VIRTUAL_INSPECTION_SET_IMAGE                  (('v' << 8) + 'v')
#define CMD_VIRTUAL_INSPECTION_CHECK_IMAGE                (('v' << 8) + 'c')
#define CMD_VIRTUAL_INSPECTION_START                      (('v' << 8) + '4')
#define CMD_VIRTUAL_INSPECTION_END                        (('V' << 8) + 'E')
#define CMD_VIRTUAL_INSPECTION_REFRESH                    (('V' << 8) + 'R')
#define CMD_INSPECTION_CLEAR        	 		(('i' << 8) + 'c')
#define CMD_SETUP_START							(('u' << 8) + 's')
#define CMD_SPB_SETUP_STATUS					(('u' << 8) + 't')
#define CMD_VIRTUAL_DEFECT_DATA                  (('v' << 8) + 'd')
#define CMD_VIRTUAL_DEBUGGING_DATA                  (('I' << 8) + 'D')
#define CMD_VIRTUAL_DEBUGGING_DATA2                  (('I' << 8) + 'S')
#define CMD_VIRTUAL_DEBUGGING_DATA3                  (('M' << 8) + 'K')
#define CMD_VIRTUAL_DEBUGGING_DATA4                  (('H' << 8) + 'S')
#define CMD_VIRTUAL_DEBUGGING_DATA5                  (('H' << 8) + 'A')

#define CMD_CAPTURE_START    		      		(('X' << 8) + 'S')
#define CMD_CAPTURE_EXIST    		      		(('X' << 8) + 'E')
#define CMD_CAPTURE_UPLOAD    		      	(('X' << 8) + 'U')
#define CMD_CAPTURE_STOP    		      		(('X' << 8) + 'T')
#define CMD_RUN                 				  (('R' << 8) + 'N')
#define CMD_CAMERA_CONTROL        	 			(('C' << 8) + 'K')
#define CMD_CAMERA_CONTROL_NORMAL_MODE        	    (('C' << 8) + 'C')
#define CMD_CAMERA_CONTROL_PROCESSING_MODE        	(('C' << 8) + 'Z')
#define CMD_CAMERA_CONTROL_RX        	 		(('C' << 8) + 'Z')
#define CMD_HPI_TEST							(('H' << 8) + 'P')
#define CMD_HPI_TEST_RESULT						(('H' << 8) + 'R')
#define CMD_STOP_SPB_TEST						(('S' << 8) + 'P')
#define CMD_HPI_PROTOCOL_TEST					(('H' << 8) + 'Q')
#define CMD_CAMERA_SETUP        	 			(('C' << 8) + 'X')
#define CMD_3D_CAMERA_DATA						(('3' << 8) + 'X')
#define CMD_CAMERA_CONFIG        	 			(('C' << 8) + 'F')
#define CMD_CAMERA_SET_PARAM					(('C' << 8) + 'P')
#define CMD_CAMERA_COMMAND_RESULT        	 	(('C' << 8) + 'U')
#define CMD_RUN_INFO							(('R' << 8) + 'F')
#define CMD_CPB_STATUS							(('C' << 8) + 'S')
#define CMD_CIS_PARTIAL_CAPTURE_MODE			(('P' << 8) + 'M')
#define CMD_READ_3D_CAMERA_SETUP				(('R' << 8) + '3')

#define CMD_INT_CAPTURE    		      		    (('I' << 8) + 'X')

#define CMD_SETUP        	 					(('s' << 8) + 'u')
#define CMD_STUDY        	 					(('s' << 8) + 't')
#define CMD_STUDY_IMAGE        	 				(('s' << 8) + 'i')
#define CMD_STUDY_RESULT        	 			(('s' << 8) + 'l')
#define CMD_RE_INSPECTION        	 			(('r' << 8) + 'r')
#define CMD_DEFECT_IMAGE_EXIST        	 		(('d' << 8) + 'e')
#define CMD_DEFECT_IMAGE        	 			(('d' << 8) + 'i')
#define CMD_DEFECT_DATA        	 				(('d' << 8) + 'd')
#define CMD_DISCARD_DEFECT_IMAGE                (('d' << 8) + 'z')
#define CMD_PROCESSED_BLOCK_COUNT				(('p' << 8) + 'b')
#define CMD_PROCESSING_STATISTIC				(('p' << 8) + 's')
#define CMD_GRADE_DATA        	 				(('g' << 8) + 'd')
#define CMD_UPLOAD_CPB_IMAGE					(('u' << 8) + 'c')

#define CMD_CAPTURE_SETUP                 		(('c' << 8) + 's')

#define CMD_SET_CAMERA_WHITE_BALANCE    (('W' << 8) + 'B')

#define CMD_IPB_RESET    (('I' << 8) + 'T')





typedef struct
{
	unsigned short 		header;
	unsigned short 		mode;					/* type of communication */
	unsigned int		length;					/* length of packet : integer*/
	unsigned short 		type;					/* command type */
	unsigned short 		command;				/* command */
	unsigned short 		destination;			/* receiver */
	unsigned short 		source;					/* sender */
	unsigned int 		packetID;				/* count of packet */
	unsigned int 		data[1];				/* data & checksum */
} TRS232Packet;


typedef struct 
{
	unsigned short 		header;
	unsigned short 		mode;					/* type of communication */
	unsigned int		length;					/* length of packet : integer*/
	unsigned short 		type;					/* command type */
	unsigned short 		command;				/* command */
	unsigned short 		destination;			/* receiver */
	unsigned short 		source;					/* sender */
	unsigned int 		packetID;				/* count of packet */
} TUSBPacketHeader;


typedef struct 
{
	unsigned short 		Header;
	unsigned short 		Command;				/* command */
	unsigned short		RequestKind;
	unsigned short		reserved;
	unsigned int		SmallDataLength;		/* length of short data*/
	unsigned int		LargeDataLength;		/* length of long data*/
} TUSBDataHeader;
	
typedef struct 
{
	unsigned short 		Header;
	unsigned short 		Command;				/* command */
	unsigned short		RequestKind;
	unsigned short		reserved;
	unsigned int		SmallDataLength;		/* length of short data*/
	unsigned int		LargeDataLength;		/* length of long data*/
} TTCPDataHeader;

typedef struct 
{
	unsigned short 		header;
	unsigned short 		mode;					/* type of communication */
	unsigned int		length;					/* length of packet : integer*/
	unsigned short 		type;					/* command type */
	unsigned short 		command;				/* command */
	unsigned short 		destination;			/* receiver */
	unsigned short 		source;					/* sender */
	unsigned int 		packetID;				/* count of packet */
	unsigned int 		data[1];				/* data & checksum */
} TMcbspPacket;

// HPI
#define MAX_HPI_SEND_SIZE_WORD				32
//#define MAX_HPI_TRANSFER_SIZE_WORD		512
//#define MAX_HPI_TRANSFER_SIZE_WORD		256
#define MAX_HPI_TRANSFER_SIZE_WORD			512
#define MAX_HPI_IMAGE_TRANSFER_SIZE_WORD	256

#define HPI_PACKET_HEADER_SIZE_WORD			5
#define MAX_HPI_PACKET_DATA_LENGTH_WORD		(MAX_HPI_TRANSFER_SIZE_WORD - HPI_PACKET_HEADER_SIZE_WORD)
#define MAX_HPI_IMAGE_PACKET_DATA_LENGTH_WORD	(MAX_HPI_IMAGE_TRANSFER_SIZE_WORD - HPI_PACKET_HEADER_SIZE_WORD)

#define HPI_STATE_NONE						0xFFFF

#define HPI_STATE_SEND_REQUEST				100
#define HPI_STATE_READ_ERR_SIZE				101
#define HPI_STATE_READ_ERR_CHECKSUM			102
#define HPI_STATE_READ_COMPLETE				103

#define HPI_STATE_SEND_LAST					200
#define HPI_STATE_PROCESSING_LAST			201
#define HPI_STATE_COMPLETE_LAST				202
#define HPI_STATE_SEND_LAST_IMAGE			203

#define HPI_STATE_RECEIVE_REQUEST			300
#define HPI_STATE_WRITE_ERR_SIZE			301
#define HPI_STATE_WRITE_ERR_CHECKSUM		302
#define HPI_STATE_WRITE_COMPLETE			303

#define HPI_STATE_RECEIVE_COMPLETE			400

//#define CPB_COM_TIMEOUT					1000
//#define CPB_COM_TIMEOUT					50
#define CPB_COM_TIMEOUT						7   //sjm chg For RunTime 5 => 6


#define TRANSFER_STATUS_IDLE			0		// cpb write it
//#define TRANSFER_STATUS_ON_WRITE		1		
#define TRANSFER_STATUS_WRITE_COMPLETE	2		// spb write it
//#define TRANSFER_STATUS_ON_RESPONSE	3		
#define TRANSFER_STATUS_PACKET_ERROR	4		// cpb write it
#define TRANSFER_STATUS_RESPONSE_READY	5		// cpb write it
//#define TRANSFER_STATUS_ON_READ		6		
#define TRANSFER_STATUS_READ_COMPLETE	7		// spb write it


typedef struct
{
	unsigned int SPB_CheckSum;
	unsigned short HPI_State;
	unsigned short PRI_Indicator;
	unsigned int SEC_Indicator;
	unsigned int Address;			// start from zero
	unsigned int DataLength_Word;	// word (int)	
	unsigned int Data[MAX_HPI_TRANSFER_SIZE_WORD];
} THPIPacket;

typedef struct
{
	unsigned int SPB_CheckSum;
	unsigned short HPI_State;
	unsigned short PRI_Indicator;
	unsigned int SEC_Indicator;
	unsigned int Address;			// start from zero
	unsigned short DataLength_Word;	// word (int)	
	unsigned short FrameCount;
	unsigned int Data[MAX_HPI_TRANSFER_SIZE_WORD];
} THPIImagePacket;

typedef struct
{
	unsigned int SPB_CheckSum;
	unsigned short HPI_State;
	unsigned short PRI_Indicator;
	unsigned int SEC_Indicator;
	unsigned int Address;
	unsigned int DataLength_Word;	// word (int)	
} THPIHeaderPacket;

#endif
